<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Slides;

class Thumbnail extends \Google\Model
{
  /**
   * The content URL of the thumbnail image. The URL to the image has a default
   * lifetime of 30 minutes. This URL is tagged with the account of the
   * requester. Anyone with the URL effectively accesses the image as the
   * original requester. Access to the image may be lost if the presentation's
   * sharing settings change. The mime type of the thumbnail image is the same
   * as specified in the `GetPageThumbnailRequest`.
   *
   * @var string
   */
  public $contentUrl;
  /**
   * The positive height in pixels of the thumbnail image.
   *
   * @var int
   */
  public $height;
  /**
   * The positive width in pixels of the thumbnail image.
   *
   * @var int
   */
  public $width;

  /**
   * The content URL of the thumbnail image. The URL to the image has a default
   * lifetime of 30 minutes. This URL is tagged with the account of the
   * requester. Anyone with the URL effectively accesses the image as the
   * original requester. Access to the image may be lost if the presentation's
   * sharing settings change. The mime type of the thumbnail image is the same
   * as specified in the `GetPageThumbnailRequest`.
   *
   * @param string $contentUrl
   */
  public function setContentUrl($contentUrl)
  {
    $this->contentUrl = $contentUrl;
  }
  /**
   * @return string
   */
  public function getContentUrl()
  {
    return $this->contentUrl;
  }
  /**
   * The positive height in pixels of the thumbnail image.
   *
   * @param int $height
   */
  public function setHeight($height)
  {
    $this->height = $height;
  }
  /**
   * @return int
   */
  public function getHeight()
  {
    return $this->height;
  }
  /**
   * The positive width in pixels of the thumbnail image.
   *
   * @param int $width
   */
  public function setWidth($width)
  {
    $this->width = $width;
  }
  /**
   * @return int
   */
  public function getWidth()
  {
    return $this->width;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Thumbnail::class, 'Google_Service_Slides_Thumbnail');
