<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Monitoring;

class MonitoredResource extends \Google\Model
{
  /**
   * Required. Values for all of the labels listed in the associated monitored
   * resource descriptor. For example, Compute Engine VM instances use the
   * labels "project_id", "instance_id", and "zone".
   *
   * @var string[]
   */
  public $labels;
  /**
   * Required. The monitored resource type. This field must match the type field
   * of a MonitoredResourceDescriptor object. For example, the type of a Compute
   * Engine VM instance is gce_instance. For a list of types, see Monitoring
   * resource types (https://cloud.google.com/monitoring/api/resources) and
   * Logging resource types
   * (https://cloud.google.com/logging/docs/api/v2/resource-list).
   *
   * @var string
   */
  public $type;

  /**
   * Required. Values for all of the labels listed in the associated monitored
   * resource descriptor. For example, Compute Engine VM instances use the
   * labels "project_id", "instance_id", and "zone".
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Required. The monitored resource type. This field must match the type field
   * of a MonitoredResourceDescriptor object. For example, the type of a Compute
   * Engine VM instance is gce_instance. For a list of types, see Monitoring
   * resource types (https://cloud.google.com/monitoring/api/resources) and
   * Logging resource types
   * (https://cloud.google.com/logging/docs/api/v2/resource-list).
   *
   * @param string $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(MonitoredResource::class, 'Google_Service_Monitoring_MonitoredResource');
