<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DatabaseMigrationService;

class SingleColumnChange extends \Google\Collection
{
  protected $collection_key = 'setValues';
  /**
   * Optional. Is the column of array type.
   *
   * @var bool
   */
  public $array;
  /**
   * Optional. The length of the array, only relevant if the column type is an
   * array.
   *
   * @var int
   */
  public $arrayLength;
  /**
   * Optional. Is the column auto-generated/identity.
   *
   * @var bool
   */
  public $autoGenerated;
  /**
   * Optional. Charset override - instead of table level charset.
   *
   * @var string
   */
  public $charset;
  /**
   * Optional. Collation override - instead of table level collation.
   *
   * @var string
   */
  public $collation;
  /**
   * Optional. Comment associated with the column.
   *
   * @var string
   */
  public $comment;
  /**
   * Optional. Custom engine specific features.
   *
   * @var array[]
   */
  public $customFeatures;
  /**
   * Optional. Column data type name.
   *
   * @var string
   */
  public $dataType;
  /**
   * Optional. Column fractional seconds precision - e.g. 2 as in timestamp (2)
   * - when relevant.
   *
   * @var int
   */
  public $fractionalSecondsPrecision;
  /**
   * Optional. Column length - e.g. 50 as in varchar (50) - when relevant.
   *
   * @var string
   */
  public $length;
  /**
   * Optional. Is the column nullable.
   *
   * @var bool
   */
  public $nullable;
  /**
   * Optional. Column precision - e.g. 8 as in double (8,2) - when relevant.
   *
   * @var int
   */
  public $precision;
  /**
   * Optional. Column scale - e.g. 2 as in double (8,2) - when relevant.
   *
   * @var int
   */
  public $scale;
  /**
   * Optional. Specifies the list of values allowed in the column.
   *
   * @var string[]
   */
  public $setValues;
  /**
   * Optional. Is the column a UDT (User-defined Type).
   *
   * @var bool
   */
  public $udt;

  /**
   * Optional. Is the column of array type.
   *
   * @param bool $array
   */
  public function setArray($array)
  {
    $this->array = $array;
  }
  /**
   * @return bool
   */
  public function getArray()
  {
    return $this->array;
  }
  /**
   * Optional. The length of the array, only relevant if the column type is an
   * array.
   *
   * @param int $arrayLength
   */
  public function setArrayLength($arrayLength)
  {
    $this->arrayLength = $arrayLength;
  }
  /**
   * @return int
   */
  public function getArrayLength()
  {
    return $this->arrayLength;
  }
  /**
   * Optional. Is the column auto-generated/identity.
   *
   * @param bool $autoGenerated
   */
  public function setAutoGenerated($autoGenerated)
  {
    $this->autoGenerated = $autoGenerated;
  }
  /**
   * @return bool
   */
  public function getAutoGenerated()
  {
    return $this->autoGenerated;
  }
  /**
   * Optional. Charset override - instead of table level charset.
   *
   * @param string $charset
   */
  public function setCharset($charset)
  {
    $this->charset = $charset;
  }
  /**
   * @return string
   */
  public function getCharset()
  {
    return $this->charset;
  }
  /**
   * Optional. Collation override - instead of table level collation.
   *
   * @param string $collation
   */
  public function setCollation($collation)
  {
    $this->collation = $collation;
  }
  /**
   * @return string
   */
  public function getCollation()
  {
    return $this->collation;
  }
  /**
   * Optional. Comment associated with the column.
   *
   * @param string $comment
   */
  public function setComment($comment)
  {
    $this->comment = $comment;
  }
  /**
   * @return string
   */
  public function getComment()
  {
    return $this->comment;
  }
  /**
   * Optional. Custom engine specific features.
   *
   * @param array[] $customFeatures
   */
  public function setCustomFeatures($customFeatures)
  {
    $this->customFeatures = $customFeatures;
  }
  /**
   * @return array[]
   */
  public function getCustomFeatures()
  {
    return $this->customFeatures;
  }
  /**
   * Optional. Column data type name.
   *
   * @param string $dataType
   */
  public function setDataType($dataType)
  {
    $this->dataType = $dataType;
  }
  /**
   * @return string
   */
  public function getDataType()
  {
    return $this->dataType;
  }
  /**
   * Optional. Column fractional seconds precision - e.g. 2 as in timestamp (2)
   * - when relevant.
   *
   * @param int $fractionalSecondsPrecision
   */
  public function setFractionalSecondsPrecision($fractionalSecondsPrecision)
  {
    $this->fractionalSecondsPrecision = $fractionalSecondsPrecision;
  }
  /**
   * @return int
   */
  public function getFractionalSecondsPrecision()
  {
    return $this->fractionalSecondsPrecision;
  }
  /**
   * Optional. Column length - e.g. 50 as in varchar (50) - when relevant.
   *
   * @param string $length
   */
  public function setLength($length)
  {
    $this->length = $length;
  }
  /**
   * @return string
   */
  public function getLength()
  {
    return $this->length;
  }
  /**
   * Optional. Is the column nullable.
   *
   * @param bool $nullable
   */
  public function setNullable($nullable)
  {
    $this->nullable = $nullable;
  }
  /**
   * @return bool
   */
  public function getNullable()
  {
    return $this->nullable;
  }
  /**
   * Optional. Column precision - e.g. 8 as in double (8,2) - when relevant.
   *
   * @param int $precision
   */
  public function setPrecision($precision)
  {
    $this->precision = $precision;
  }
  /**
   * @return int
   */
  public function getPrecision()
  {
    return $this->precision;
  }
  /**
   * Optional. Column scale - e.g. 2 as in double (8,2) - when relevant.
   *
   * @param int $scale
   */
  public function setScale($scale)
  {
    $this->scale = $scale;
  }
  /**
   * @return int
   */
  public function getScale()
  {
    return $this->scale;
  }
  /**
   * Optional. Specifies the list of values allowed in the column.
   *
   * @param string[] $setValues
   */
  public function setSetValues($setValues)
  {
    $this->setValues = $setValues;
  }
  /**
   * @return string[]
   */
  public function getSetValues()
  {
    return $this->setValues;
  }
  /**
   * Optional. Is the column a UDT (User-defined Type).
   *
   * @param bool $udt
   */
  public function setUdt($udt)
  {
    $this->udt = $udt;
  }
  /**
   * @return bool
   */
  public function getUdt()
  {
    return $this->udt;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SingleColumnChange::class, 'Google_Service_DatabaseMigrationService_SingleColumnChange');
