<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ContainerAnalysis;

class ContaineranalysisGoogleDevtoolsCloudbuildV1DependencyGitSourceRepository extends \Google\Model
{
  /**
   * The Developer Connect Git repository link formatted as
   * `projects/locations/connections/gitRepositoryLink`
   *
   * @var string
   */
  public $developerConnect;
  /**
   * Location of the Git repository.
   *
   * @var string
   */
  public $url;

  /**
   * The Developer Connect Git repository link formatted as
   * `projects/locations/connections/gitRepositoryLink`
   *
   * @param string $developerConnect
   */
  public function setDeveloperConnect($developerConnect)
  {
    $this->developerConnect = $developerConnect;
  }
  /**
   * @return string
   */
  public function getDeveloperConnect()
  {
    return $this->developerConnect;
  }
  /**
   * Location of the Git repository.
   *
   * @param string $url
   */
  public function setUrl($url)
  {
    $this->url = $url;
  }
  /**
   * @return string
   */
  public function getUrl()
  {
    return $this->url;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ContaineranalysisGoogleDevtoolsCloudbuildV1DependencyGitSourceRepository::class, 'Google_Service_ContainerAnalysis_ContaineranalysisGoogleDevtoolsCloudbuildV1DependencyGitSourceRepository');
