<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class NetworkEndpointGroupsScopedList extends \Google\Collection
{
  protected $collection_key = 'networkEndpointGroups';
  protected $networkEndpointGroupsType = NetworkEndpointGroup::class;
  protected $networkEndpointGroupsDataType = 'array';
  protected $warningType = NetworkEndpointGroupsScopedListWarning::class;
  protected $warningDataType = '';

  /**
   * Output only. [Output Only] The list ofnetwork endpoint groups that are
   * contained in this scope.
   *
   * @param NetworkEndpointGroup[] $networkEndpointGroups
   */
  public function setNetworkEndpointGroups($networkEndpointGroups)
  {
    $this->networkEndpointGroups = $networkEndpointGroups;
  }
  /**
   * @return NetworkEndpointGroup[]
   */
  public function getNetworkEndpointGroups()
  {
    return $this->networkEndpointGroups;
  }
  /**
   * Output only. [Output Only] An informational warning that replaces the list
   * of network endpoint groups when the list is empty.
   *
   * @param NetworkEndpointGroupsScopedListWarning $warning
   */
  public function setWarning(NetworkEndpointGroupsScopedListWarning $warning)
  {
    $this->warning = $warning;
  }
  /**
   * @return NetworkEndpointGroupsScopedListWarning
   */
  public function getWarning()
  {
    return $this->warning;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(NetworkEndpointGroupsScopedList::class, 'Google_Service_Compute_NetworkEndpointGroupsScopedList');
