<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Bigquery;

class TableList extends \Google\Collection
{
  protected $collection_key = 'tables';
  /**
   * A hash of this page of results.
   *
   * @var string
   */
  public $etag;
  /**
   * The type of list.
   *
   * @var string
   */
  public $kind;
  /**
   * A token to request the next page of results.
   *
   * @var string
   */
  public $nextPageToken;
  protected $tablesType = TableListTables::class;
  protected $tablesDataType = 'array';
  /**
   * The total number of tables in the dataset.
   *
   * @var int
   */
  public $totalItems;

  /**
   * A hash of this page of results.
   *
   * @param string $etag
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * The type of list.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * A token to request the next page of results.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * Tables in the requested dataset.
   *
   * @param TableListTables[] $tables
   */
  public function setTables($tables)
  {
    $this->tables = $tables;
  }
  /**
   * @return TableListTables[]
   */
  public function getTables()
  {
    return $this->tables;
  }
  /**
   * The total number of tables in the dataset.
   *
   * @param int $totalItems
   */
  public function setTotalItems($totalItems)
  {
    $this->totalItems = $totalItems;
  }
  /**
   * @return int
   */
  public function getTotalItems()
  {
    return $this->totalItems;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(TableList::class, 'Google_Service_Bigquery_TableList');
