<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Aiplatform;

class GoogleCloudAiplatformV1CompletionStats extends \Google\Model
{
  /**
   * Output only. The number of entities for which any error was encountered.
   *
   * @var string
   */
  public $failedCount;
  /**
   * Output only. In cases when enough errors are encountered a job, pipeline,
   * or operation may be failed as a whole. Below is the number of entities for
   * which the processing had not been finished (either in successful or failed
   * state). Set to -1 if the number is unknown (for example, the operation
   * failed before the total entity number could be collected).
   *
   * @var string
   */
  public $incompleteCount;
  /**
   * Output only. The number of entities that had been processed successfully.
   *
   * @var string
   */
  public $successfulCount;
  /**
   * Output only. The number of the successful forecast points that are
   * generated by the forecasting model. This is ONLY used by the forecasting
   * batch prediction.
   *
   * @var string
   */
  public $successfulForecastPointCount;

  /**
   * Output only. The number of entities for which any error was encountered.
   *
   * @param string $failedCount
   */
  public function setFailedCount($failedCount)
  {
    $this->failedCount = $failedCount;
  }
  /**
   * @return string
   */
  public function getFailedCount()
  {
    return $this->failedCount;
  }
  /**
   * Output only. In cases when enough errors are encountered a job, pipeline,
   * or operation may be failed as a whole. Below is the number of entities for
   * which the processing had not been finished (either in successful or failed
   * state). Set to -1 if the number is unknown (for example, the operation
   * failed before the total entity number could be collected).
   *
   * @param string $incompleteCount
   */
  public function setIncompleteCount($incompleteCount)
  {
    $this->incompleteCount = $incompleteCount;
  }
  /**
   * @return string
   */
  public function getIncompleteCount()
  {
    return $this->incompleteCount;
  }
  /**
   * Output only. The number of entities that had been processed successfully.
   *
   * @param string $successfulCount
   */
  public function setSuccessfulCount($successfulCount)
  {
    $this->successfulCount = $successfulCount;
  }
  /**
   * @return string
   */
  public function getSuccessfulCount()
  {
    return $this->successfulCount;
  }
  /**
   * Output only. The number of the successful forecast points that are
   * generated by the forecasting model. This is ONLY used by the forecasting
   * batch prediction.
   *
   * @param string $successfulForecastPointCount
   */
  public function setSuccessfulForecastPointCount($successfulForecastPointCount)
  {
    $this->successfulForecastPointCount = $successfulForecastPointCount;
  }
  /**
   * @return string
   */
  public function getSuccessfulForecastPointCount()
  {
    return $this->successfulForecastPointCount;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudAiplatformV1CompletionStats::class, 'Google_Service_Aiplatform_GoogleCloudAiplatformV1CompletionStats');
