<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Adsense;

class AdBlockingRecoveryTag extends \Google\Model
{
  /**
   * Error protection code that can be used in conjunction with the tag. It'll
   * display a message to users if an [ad blocking extension blocks their access
   * to your site](https://support.google.com/adsense/answer/11575480).
   *
   * @var string
   */
  public $errorProtectionCode;
  /**
   * The ad blocking recovery tag. Note that the message generated by the tag
   * can be blocked by an ad blocking extension. If this is not your desired
   * outcome, then you'll need to use it in conjunction with the error
   * protection code.
   *
   * @var string
   */
  public $tag;

  /**
   * Error protection code that can be used in conjunction with the tag. It'll
   * display a message to users if an [ad blocking extension blocks their access
   * to your site](https://support.google.com/adsense/answer/11575480).
   *
   * @param string $errorProtectionCode
   */
  public function setErrorProtectionCode($errorProtectionCode)
  {
    $this->errorProtectionCode = $errorProtectionCode;
  }
  /**
   * @return string
   */
  public function getErrorProtectionCode()
  {
    return $this->errorProtectionCode;
  }
  /**
   * The ad blocking recovery tag. Note that the message generated by the tag
   * can be blocked by an ad blocking extension. If this is not your desired
   * outcome, then you'll need to use it in conjunction with the error
   * protection code.
   *
   * @param string $tag
   */
  public function setTag($tag)
  {
    $this->tag = $tag;
  }
  /**
   * @return string
   */
  public function getTag()
  {
    return $this->tag;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AdBlockingRecoveryTag::class, 'Google_Service_Adsense_AdBlockingRecoveryTag');
