<?php
/*
 * QrdaReportServiceTest.php
 * @package openemr
 * @link      http://www.open-emr.org
 * @author    Stephen Nielson <snielson@discoverandchange.com>
 * @copyright Copyright (c) 2026 Stephen Nielson <snielson@discoverandchange.com>
 * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3
 */

namespace OpenEMR\Tests\Services\Qrda;

use OpenEMR\Services\PatientService;
use OpenEMR\Services\Qrda\QrdaReportService;
use OpenEMR\Tests\Fixtures\FixtureManager;
use PHPUnit\Framework\TestCase;
use DOMDocument;

class QrdaReportServiceTest extends TestCase {

    private FixtureManager $fixtureManager;
    protected function setUp(): void
    {
        parent::setUp(); // TODO: Change the autogenerated stub
        $this->fixtureManager = new FixtureManager();
    }
    protected function tearDown(): void
    {
        parent::tearDown(); // TODO: Change the autogenerated stub
        $this->fixtureManager->removePatientFixtures();
    }

    public function testGenerateCategoryIIIXml(): void
    {
        $measureFolder = __DIR__ . '/../../../../ccdaservice/node_modules/oe-cqm-parsers/2024_reporting_period/json_measures/CMS122v12';
        $measureFile = $measureFolder . '/CMS122v12.json';
        if (!file_exists($measureFile)) {
            $this->fail("Measure file {$measureFile} does not exist. Make sure the oe-cqm-parsers module is installed.");
            return;
        }

        $patientFixture = $this->fixtureManager->getSinglePatientFixture();
        $this->fixtureManager->installSinglePatientFixture($patientFixture);
        $patientService = new PatientService();
        $patientResult = $patientService->search(['pubpid' => $patientFixture['pubpid']]);
        $this->assertTrue($patientResult->hasData(), "Patient fixture was not installed correctly.");
        $patient = $patientResult->getFirstDataResult();
        $qrdaReportService = new QrdaReportService();
        $cat3XmlString = $qrdaReportService->generateCategoryIIIXml($patient['pid'], [$measureFolder]);
        $this->assertNotEmpty($cat3XmlString, "Generated Category III XML should not be empty.");
        $cat3Xml = $this->getDomXml($cat3XmlString);
        // if we can parse the structure and validate a basic element, we're going to treat this as a smoke test for now.
        $this->assertEquals('ClinicalDocument', $cat3Xml->documentElement->nodeName);
    }

    private function getDomXml(string $xmlContent): \DOMDocument
    {
        $dom = new DOMDocument();
        $dom->preserveWhiteSpace = false;
        $dom->formatOutput = false;
        if (!$dom->loadXML($xmlContent, LIBXML_NOBLANKS)) {
            throw new \RuntimeException('Invalid XML');
        }
        return $dom;
    }
}
