<?php

namespace OpenEMR\Tests\Integration\RestControllers\Subscriber;

use OpenEMR\Common\Session\SessionUtil;
use OpenEMR\Core\Kernel;
use OpenEMR\RestControllers\Subscriber\SiteSetupListener;
use PHPUnit\Framework\Attributes\Test;
use PHPUnit\Framework\TestCase;
use Symfony\Component\EventDispatcher\EventDispatcher;
use Symfony\Component\HttpFoundation\HeaderBag;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\ServerBag;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\KernelEvents;

class SiteSetupListenerTest extends TestCase
{
    protected function tearDown(): void
    {
        parent::tearDown(); // TODO: Change the autogenerated stub
        if (session_status() !== PHP_SESSION_NONE) {
            SessionUtil::oauthSessionCookieDestroy();
        }
    }

    #[Test]
    public function testOnKernelRequest(): void
    {
        $this->markTestSkipped("Skipping test for onKernelRequest method until we can figure out how to handle the require_once with globals.php allowing only a single test to exercise the SiteListener");
//        $listener = new SiteSetupListener();
//        $site = 'default';
//        // Simulate a request event
//        $request = $this->createMock(Request::class);
//        $request->server = $this->createMock(ServerBag::class);
//        $request->attributes = $this->createMock(ParameterBag::class);
//        $request->attributes->expects($this->once())->method('set')
//            ->with('siteId', $site);
//
//        $request->headers = $this->createMock(HeaderBag::class);
//        $request->headers->expects($this->once())->method('get')
//            ->with('APICSRFTOKEN')
//            ->willReturn(null); // Simulating no CSRF token for this test
//        $request->expects($this->once())->method('getPathInfo')
//            ->willReturn('/' . $site . '/apis/');
//        $event = $this->createMock(RequestEvent::class);
//        $event->expects($this->atLeastOnce())
//            ->method('getRequest')
//            ->willReturn($request);
//
//        $kernel = $this->createMock(\OpenEMR\Core\OEHttpKernel::class);
//        $dispatcher = $this->createMock(EventDispatcher::class);
//        $kernel->expects($this->atLeastOnce())->method('getEventDispatcher')
//            ->willReturn($dispatcher);
//        $event->expects($this->atLeastOnce())->method('getKernel')
//            ->willReturn($kernel);
//        // Call the method and assert no exceptions are thrown
//        var_dump("executing onKernelRequest");
//        $listener->onKernelRequest($event);
////        var_dump($_SESSION);
//
//        // now we need to check to make sure session was started
//        $this->assertEquals(PHP_SESSION_ACTIVE, session_status(), "Session should be active after onKernelRequest call");
//
//        $this->assertInstanceOf(Kernel::class, $GLOBALS['kernel'], "Kernel should be set in globals after onKernelRequest call");
//        $this->assertArrayHasKey("site_id", $_SESSION, "Session should have siteId set after onKernelRequest call");
//        $this->assertEquals($site, $_SESSION['site_id'], "Session site_id should match the site set in onKernelRequest");
//        $this->assertEquals('apiOpenEMR', session_name(), "Session name should be 'apiOpenEMR' after onKernelRequest call");
    }
    public function testOnKernelRequestFailsInvalidCSRFToken(): void
    {
        $this->markTestIncomplete("Need to implement test for invalid CSRF token handling in SiteSetupListener");
    }

    public function testOnKernelRequestFailsMissingSiteDirectory(): void
    {
        $this->markTestIncomplete("Need to implement test for missing site directory handling in SiteSetupListener");
    }

    public function testOnKernelRequestFailsInvalidSiteIdFormat(): void
    {
        $this->markTestIncomplete("Need to implement test for invalid site ID format handling in SiteSetupListener");
    }

    public function testOnKernelRequestFailsNoSiteId(): void
    {
        $this->markTestIncomplete("Need to implement test for no site ID handling in SiteSetupListener");
    }

    public function testOnKernelRequestValidCSRFToken(): void
    {
        $this->markTestIncomplete("Need to implement test for valid CSRF token handling in SiteSetupListener");
    }

    #[Test]
    public function testGetSubscribedEvents(): void
    {
        $events = SiteSetupListener::getSubscribedEvents();
        $this->assertArrayHasKey(KernelEvents::REQUEST, $events);
        $this->assertIsArray($events[KernelEvents::REQUEST]);
        $this->assertCount(1, $events[KernelEvents::REQUEST]);
        $this->assertEquals('onKernelRequest', $events[KernelEvents::REQUEST][0][0]);
        $this->assertEquals(100, $events[KernelEvents::REQUEST][0][1]);
    }
}
