/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.html.mustache.diagrams;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.schemaspy.model.Database;
import org.schemaspy.model.ProgressListener;
import org.schemaspy.model.Table;
import org.schemaspy.output.OutputException;
import org.schemaspy.output.diagram.DiagramResult;
import org.schemaspy.output.diagram.RenderException;
import org.schemaspy.output.diagram.SummaryDiagram;
import org.schemaspy.output.dot.schemaspy.DotFormatter;
import org.schemaspy.output.html.mustache.diagrams.MustacheSummaryDiagramResults;
import org.schemaspy.util.DefaultPrintWriter;
import org.schemaspy.view.MustacheTableDiagram;

public class MustacheSummaryDiagramFactory {
    private static final String FILE_PREFIX = "relationships";
    private static final String FAILED_DOT = "Failed to produce dot: ";
    private static final String FAILED_DIAGRAM = "Failed to produce diagram for: ";
    private final DotFormatter dotProducer;
    private final SummaryDiagram diagramFactory;
    private final boolean hasRealConstraints;
    private final boolean hasImpliedConstraints;
    private final Path summaryDir;

    public MustacheSummaryDiagramFactory(DotFormatter dotProducer, SummaryDiagram diagramFactory, boolean hasRealConstraints, boolean hasImpliedConstraints, File outputDir) {
        this.dotProducer = dotProducer;
        this.diagramFactory = diagramFactory;
        this.hasRealConstraints = hasRealConstraints;
        this.hasImpliedConstraints = hasImpliedConstraints;
        this.summaryDir = outputDir.toPath().resolve("diagrams").resolve("summary");
    }

    public MustacheSummaryDiagramResults generateSummaryDiagrams(Database database, Collection<Table> tables, ProgressListener progressListener) throws IOException {
        if (tables.isEmpty()) {
            return new MustacheSummaryDiagramResults(Collections.emptyList(), Collections.emptyList());
        }
        ArrayList<MustacheTableDiagram> diagrams = new ArrayList<MustacheTableDiagram>();
        ArrayList<OutputException> outputExceptions = new ArrayList<OutputException>();
        Files.createDirectories(this.summaryDir, new FileAttribute[0]);
        if (this.hasRealConstraints) {
            File realCompactDot = this.summaryDir.resolve("relationships.real.compact.dot").toFile();
            try (DefaultPrintWriter out = new DefaultPrintWriter(realCompactDot);){
                this.dotProducer.writeSummaryRealRelationships(database, tables, true, (PrintWriter)out);
                DiagramResult results = this.diagramFactory.generateSummaryDiagram(realCompactDot, "relationships.real.compact");
                MustacheTableDiagram realCompactDiagram = new MustacheTableDiagram("Compact", results, false);
                realCompactDiagram.setActive(true);
                diagrams.add(realCompactDiagram);
            }
            catch (IOException ioexception) {
                outputExceptions.add(new OutputException(FAILED_DOT + realCompactDot.toString(), (Throwable)ioexception));
            }
            catch (RenderException renderException) {
                outputExceptions.add(new OutputException(FAILED_DIAGRAM + realCompactDot.toString(), (Throwable)renderException));
            }
            this.generateRealLarge(database, tables, diagrams, outputExceptions);
        }
        progressListener.graphingSummaryProgressed();
        if (this.hasImpliedConstraints) {
            this.generateImpliedCompact(database, tables, diagrams, outputExceptions);
            this.generateImpliedLarge(database, tables, diagrams, outputExceptions);
        }
        if (!diagrams.isEmpty()) {
            ((MustacheTableDiagram)diagrams.get(0)).setActive(true);
        }
        return new MustacheSummaryDiagramResults(diagrams, outputExceptions);
    }

    private void generateRealLarge(Database database, Collection<Table> tables, List<MustacheTableDiagram> diagrams, List<OutputException> outputExceptions) {
        File realLargeDot = this.summaryDir.resolve("relationships.real.large.dot").toFile();
        try (DefaultPrintWriter out = new DefaultPrintWriter(realLargeDot);){
            this.dotProducer.writeSummaryRealRelationships(database, tables, false, (PrintWriter)out);
            DiagramResult results = this.diagramFactory.generateSummaryDiagram(realLargeDot, "relationships.real.large");
            MustacheTableDiagram realLargeDiagram = new MustacheTableDiagram("Large", results, false);
            diagrams.add(realLargeDiagram);
        }
        catch (IOException ioexception) {
            outputExceptions.add(new OutputException(FAILED_DOT + realLargeDot.toString(), (Throwable)ioexception));
        }
        catch (RenderException renderException) {
            outputExceptions.add(new OutputException(FAILED_DIAGRAM + realLargeDot.toString(), (Throwable)renderException));
        }
    }

    private void generateImpliedCompact(Database database, Collection<Table> tables, List<MustacheTableDiagram> diagrams, List<OutputException> outputExceptions) {
        File impliedCompactDot = this.summaryDir.resolve("relationships.implied.compact.dot").toFile();
        try (DefaultPrintWriter out = new DefaultPrintWriter(impliedCompactDot);){
            this.dotProducer.writeSummaryAllRelationships(database, tables, true, (PrintWriter)out);
            DiagramResult results = this.diagramFactory.generateSummaryDiagram(impliedCompactDot, "relationships.implied.compact");
            MustacheTableDiagram impliedCompactDiagram = new MustacheTableDiagram("Compact Implied", results, true);
            diagrams.add(impliedCompactDiagram);
        }
        catch (IOException ioexception) {
            outputExceptions.add(new OutputException(FAILED_DOT + impliedCompactDot.toString(), (Throwable)ioexception));
        }
        catch (RenderException renderException) {
            outputExceptions.add(new OutputException(FAILED_DIAGRAM + impliedCompactDot.toString(), (Throwable)renderException));
        }
    }

    private void generateImpliedLarge(Database database, Collection<Table> tables, List<MustacheTableDiagram> diagrams, List<OutputException> outputExceptions) {
        File impliedLargeDot = this.summaryDir.resolve("relationships.implied.large.dot").toFile();
        try (DefaultPrintWriter out = new DefaultPrintWriter(impliedLargeDot);){
            this.dotProducer.writeSummaryAllRelationships(database, tables, false, (PrintWriter)out);
            DiagramResult results = this.diagramFactory.generateSummaryDiagram(impliedLargeDot, "relationships.implied.large");
            MustacheTableDiagram impliedLargeDiagram = new MustacheTableDiagram("Large Implied", results, true);
            diagrams.add(impliedLargeDiagram);
        }
        catch (IOException ioexception) {
            outputExceptions.add(new OutputException(FAILED_DOT + impliedLargeDot.toString(), (Throwable)ioexception));
        }
        catch (RenderException renderException) {
            outputExceptions.add(new OutputException(FAILED_DIAGRAM + impliedLargeDot.toString(), (Throwable)renderException));
        }
    }
}

