<?php

declare(strict_types=1);

namespace Laminas\Filter;

use Laminas\ModuleManager\ModuleManager;

class Module
{
    /**
     * Return default laminas-filter configuration for laminas-mvc applications.
     */
    public function getConfig()
    {
        $provider = new ConfigProvider();

        return [
            'service_manager' => $provider->getDependencyConfig(),
        ];
    }

    /**
     * Register a specification for the FilterManager with the ServiceListener.
     *
     * @deprecated Since 2.40.0 This method is not necessary for module manager and will be removed in 3.0
     *
     * @param ModuleManager $moduleManager
     * @return void
     */
    public function init($moduleManager)
    {
        $event           = $moduleManager->getEvent();
        $container       = $event->getParam('ServiceManager');
        $serviceListener = $container->get('ServiceListener');

        $serviceListener->addServiceManager(
            'FilterManager',
            'filters',
            FilterProviderInterface::class,
            'getFilterConfig'
        );
    }
}
