<?php

namespace OpenEMR\Tests\Unit\Services;

use OpenEMR\Events\Services\LogoFilterEvent;
use OpenEMR\Services\LogoService;
use PHPUnit\Framework\TestCase;
use Symfony\Component\EventDispatcher\EventDispatcher;

class LogoServiceTest extends TestCase
{
    protected function setUp(): void
    {
        parent::setUp(); // TODO: Change the autogenerated stub
        // TODO: remove this when the LogoService is refactored to not use the global webroot
        $GLOBALS['web_root'] = ''; // needed by the ModulesApplication class (called by LogoService)
    }

    public function testLogoEventCanOverrideLogoPath(): void
    {
        $logoType = "logoPathThatDoesNotExist/logo";
        // has to be a file that exists in the zend_modules or custom_modules directory for safe path inclusion
        $logoPathUpdated = "/interface/modules/zend_modules/public/images/close.png";
        $eventDispatcher = new EventDispatcher();
        $eventDispatcher->addListener(LogoFilterEvent::EVENT_NAME, function (LogoFilterEvent $event) use ($logoType, $logoPathUpdated): void {
            $this->assertEquals($logoType, $event->getLogoType(), "Logo type was not populated");
            $this->assertEquals("", $event->getWebPath());
            $this->assertEquals("", $event->getFilePath());
            // Override the logo path
            $event->setWebPath($logoPathUpdated);
        });
        $logoService = new LogoService($eventDispatcher);
        $logoPath = $logoService->getLogo($logoType);
        $this->assertEquals($logoPathUpdated, $logoPath, "Logo path was not updated by event listener");
    }
}
