<?php

// Copyright (C) 2010-2011 Aron Racho <aron@mi-squred.com>
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

namespace OpenEMR\ClinicalDecisionRules\Interface\RuleLibrary;

/**
 * Enumerates rule types
 * todo turn this into a real enum
 * @author aron
 */
class RuleType
{
    const ActiveAlert = "activealert";
    const PassiveAlert = "passivealert";
    const CQM = "cqm";
    const AMC = "amc";
    const PatientReminder = "patientreminder";

    function __construct(public $code, public $lbl)
    {
    }

    /**
     *
     * @param string $value
     * @return RuleType
     */
    public static function from($code)
    {
        $map = self::map();
        return $map[$code];
    }

    public static function values()
    {
        $map = self::map();
        return array_keys($map);
    }

    private static function map()
    {
        $map = [
            self::ActiveAlert => new RuleType(self::ActiveAlert, xl('Active Alert')),
            self::PassiveAlert => new RuleType(self::PassiveAlert, xl('Passive Alert')),
            // not yet supported
//            self::CQM   =>  new OpenEMR\ClinicalDecisionRules\Interface\RuleLibrary\RuleType( self::CQM, xl( 'CQM' ) ),
//            self::AMC   =>  new OpenEMR\ClinicalDecisionRules\Interface\RuleLibrary\RuleType( self::AMC, xl( 'AMC' ) ),
            self::PatientReminder => new RuleType(self::PatientReminder, xl('Patient Reminder'))
        ];
        return $map;
    }
}
