<?php

/**
 * interface/modules/zend_modules/module/Documents/Module.php
 *
 * @package   OpenEMR
 * @link      https://www.open-emr.org
 * @author    Basil PT <basil@zhservices.com>
 * @copyright Copyright (c) 2013 Z&H Consultancy Services Private Limited <sam@zhservices.com>
 * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3
 */

namespace Documents;

use Laminas\Mvc\ModuleRouteListener;
use Laminas\Mvc\MvcEvent;
use Laminas\ModuleManager\Feature\AutoloaderProviderInterface;
use Laminas\ModuleManager\ModuleManager;
use Documents\Model\DocumentsTable;

class Module implements AutoloaderProviderInterface
{
    public function onBootstrap(MvcEvent $e)
    {
        $eventManager        = $e->getApplication()->getEventManager();
        $moduleRouteListener = new ModuleRouteListener();
        $moduleRouteListener->attach($eventManager);
    }

    public function init(ModuleManager $mm)
    {
        $mm->getEventManager()->getSharedManager()->attach(__NAMESPACE__, 'dispatch', function ($e): void {
            $controller             = $e->getTarget();
            $route                      = $controller->getEvent()->getRouteMatch();
            $controller_name    = $route->getParam('controller');
            switch ($controller_name) {
                default:
                    $controller->layout('documents/layout');
            };
            $controller->getEvent()->getViewModel()->setVariables([
                        'current_controller' => $route->getParam('controller'),
                        'current_action'         => $route->getParam('action'),
                    ]);
        });
    }

    public function getConfig()
    {
        return include __DIR__ . '/config/module.config.php';
    }

    public function getAutoloaderConfig()
    {
        return [
        \Laminas\Loader\StandardAutoloader::class => [
          'namespaces' => [
            __NAMESPACE__ => __DIR__ . '/src/' . __NAMESPACE__,
          ],
        ],
        ];
    }
}
